﻿import tkinter as tk
from tkinter import messagebox
import requests
import random
import time
from datetime import datetime
import threading

# Путь к файлам
name_file_path = r"C:\Users\1\Desktop\VS 2022\Изменить имена и фамилии ВК\Имена и Фамилии.txt"
blacklist_file_path = r"C:\Users\1\Desktop\VS 2022\Изменить имена и фамилии ВК\Blacklist for ИФ.txt"
token_file_path = r"C:\Users\1\Desktop\VS 2022\Изменить имена и фамилии ВК\Токены для изменения ИФ.txt"
token_blacklist_file_path = r"C:\Users\1\Desktop\VS 2022\Изменить имена и фамилии ВК\Blacklist for tokens.txt"
output_file_path = r"C:\Users\1\Desktop\VS 2022\Изменить имена и фамилии ВК\Сохранить Новые ИФ.txt"
state_file_path = r"C:\Users\1\Desktop\VS 2022\Изменить имена и фамилии ВК\checkbox_state.txt"
delay_state_file_path = r"C:\Users\1\Desktop\VS 2022\Изменить имена и фамилии ВК\delay_state.txt"

# Список гласных
vowels = 'аеёиоуыэюя'

# Глобальные переменные для статистики и управления
success_count = 0
failure_count = 0
success_tokens = []
failure_tokens = []
is_running = False

# Функция для изменения имени, фамилии и даты рождения
def change_name_surname(name, surname, token, change_birth_date):
    if surname[-1].lower() in vowels:
        sex = 1  # Женский пол
    else:
        sex = 2  # Мужской пол

    birth_date = None
    if change_birth_date:
        birth_year = random.randint(int(birth_year_from_entry.get()), int(birth_year_to_entry.get()))
        birth_month = random.randint(1, 12)
        if birth_month in [4, 6, 9, 11]:
            max_day = 30
        elif birth_month == 2:
            max_day = 29 if (birth_year % 4 == 0 and (birth_year % 100 != 0 or birth_year % 400 == 0)) else 28
        else:
            max_day = 31
        birth_day = random.randint(1, max_day)
        birth_date = f"{birth_day:02}.{birth_month:02}.{birth_year}"

    url = f'https://api.vk.com/method/account.saveProfileInfo?v=5.131&access_token={token}'
    data = {
        'first_name': name,
        'last_name': surname,
        'sex': sex
    }
    if birth_date:
        data['bdate'] = birth_date

    response = requests.post(url, data=data)
    return response.json(), sex, birth_date

# Функция для чтения данных из файла
def read_file(file_path):
    try:
        with open(file_path, 'r', encoding='utf-8') as file:
            lines = [line.strip() for line in file if line.strip()]
            print(f"Прочитано {len(lines)} строк из файла: {file_path}")
            return lines
    except Exception as e:
        messagebox.showerror("Ошибка", f"Не удалось прочитать файл: {file_path}\nОшибка: {str(e)}")
        return []

# Функция для записи данных в файл
def write_file(file_path, data):
    try:
        with open(file_path, 'a', encoding='utf-8') as file:
            file.write(data + '\n')
    except Exception as e:
        messagebox.showerror("Ошибка", f"Не удалось записать в файл: {file_path}\nОшибка: {str(e)}")

# Функция для записи разделителя
def write_separator():
    try:
        with open(output_file_path, 'a', encoding='utf-8') as file:
            file.write("\n----\n")
    except Exception as e:
        messagebox.showerror("Ошибка", f"Не удалось записать разделитель в файл: {output_file_path}\nОшибка: {str(e)}")

# Функция для получения неиспользованного токена
def get_unused_token():
    tokens = read_file(token_file_path)
    used_tokens = read_file(token_blacklist_file_path)
    used_tokens_set = set(used_tokens)  # Для быстрого поиска
    available_tokens = [token for token in tokens if token not in used_tokens_set and token.strip()]
    print(f"Доступных токенов: {len(available_tokens)}")
    token_count_label.config(text=f"Количество доступных токенов: {len(available_tokens)}")
    if not available_tokens:
        update_log("Все токены находятся в черном списке.")
    return available_tokens[0] if available_tokens else None

# Функция для обновления текста в реальном времени
def update_log(text):
    log_text.insert(tk.END, text + "\n")
    log_text.see(tk.END)
    root.update_idletasks()

# Основная функция для изменения имен и фамилий в отдельном потоке
def run_process():
    global success_count, failure_count, success_tokens, failure_tokens, is_running
    success_count = 0
    failure_count = 0
    success_tokens = []
    failure_tokens = []
    is_running = True

    write_separator()
    update_log("=== Процесс запущен ===")
    names_and_surnames = read_file(name_file_path)
    blacklist = read_file(blacklist_file_path)

    if not names_and_surnames:
        update_log("Список имён и фамилий пуст.")
        is_running = False
        return

    try:
        delay_min = float(delay_min_entry.get())
        delay_max = float(delay_max_entry.get())
        if delay_min < 0 or delay_max < 0 or delay_min > delay_max:
            raise ValueError("Некорректный диапазон задержки.")
    except ValueError:
        messagebox.showerror("Ошибка", "Пожалуйста, введите корректные значения для задержки.")
        is_running = False
        return

    change_birth_date = birth_date_var.get()

    # Проверка наличия доступных токенов
    token = get_unused_token()
    if not token:
        update_log("Нет доступных токенов. Все токены находятся в черном списке.")
        is_running = False
        return

    for line in names_and_surnames:
        if not is_running:
            update_log("Процесс остановлен пользователем.")
            break
        if line in blacklist:
            continue
        try:
            name, surname = line.split()
        except ValueError:
            update_log(f"Неверный формат строки: '{line}', пропуск.")
            failure_count += 1
            continue
        token = get_unused_token()
        if not token:
            update_log("Нет доступных токенов.")
            break

        response, sex, birth_date = change_name_surname(name, surname, token, change_birth_date)

        sex_str = "мужской" if sex == 2 else "женский"
        current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")

        if "response" in response:
            status = "Успешно"
            log_message = f"[{status}] {name} {surname} | Пол: {sex_str}"
            if birth_date:
                log_message += f" | Дата рождения: {birth_date}"
            log_message += f" | Время: {current_time}"
            update_log(log_message)
            success_count += 1
            success_tokens.append(token)
            write_file(blacklist_file_path, line)
            write_file(output_file_path, f"{name} {surname}")
            write_file(token_blacklist_file_path, token)
        else:
            if "error" in response:
                error_code = response["error"]["error_code"]
                error_msg = response["error"]["error_msg"]

                update_log(f"Ошибка при первой попытке изменения для {name} {surname} | Код ошибки: {error_code}, повторная попытка через 5-10 секунд...")
                time.sleep(random.uniform(5, 10))

                response, sex, birth_date = change_name_surname(name, surname, token, change_birth_date)

                if "response" in response:
                    status = "Успешно (вторая попытка)"
                    log_message = f"[{status}] {name} {surname} | Пол: {sex_str}"
                    if birth_date:
                        log_message += f" | Дата рождения: {birth_date}"
                    log_message += f" | Время: {current_time}"
                    update_log(log_message)
                    success_count += 1
                    success_tokens.append(token)
                    write_file(blacklist_file_path, line)
                    write_file(output_file_path, f"{name} {surname}")
                    write_file(token_blacklist_file_path, token)
                else:
                    if "error" in response:
                        error_code = response["error"]["error_code"]
                        error_msg = response["error"]["error_msg"]
                        update_log(f"Ошибка при второй попытке изменения для {name} {surname} | Код ошибки: {error_code}, аккаунт пропущен.")
                        failure_count += 1
                        failure_tokens.append(token)
                        write_file(output_file_path, f"{name} {surname} | Код ошибки: {error_code}")
                        write_file(token_blacklist_file_path, token)
                        write_file(blacklist_file_path, line)

        success_label.config(text=f"Успешно: {success_count}")
        failure_label.config(text=f"Неуспешно: {failure_count}")

        delay = random.uniform(delay_min, delay_max)
        update_log(f"Задержка: {delay:.1f} сек")
        time.sleep(delay)

    update_log("=== Процесс завершён ===")
    is_running = False

# Функция для загрузки количества токенов
def load_token_count():
    tokens = read_file(token_file_path)
    used_tokens = read_file(token_blacklist_file_path)
    used_tokens_set = set(used_tokens)  # Для быстрого поиска
    available_tokens = [token for token in tokens if token not in used_tokens_set and token.strip()]
    blacklisted_tokens = [token for token in tokens if token in used_tokens_set]
    print(f"Всего токенов: {len(tokens)}")
    print(f"Доступных токенов при запуске: {len(available_tokens)}")
    print(f"Токенов в черном списке: {len(blacklisted_tokens)}")
    total_token_count_label.config(text=f"Количество всего токенов: {len(tokens)}")
    token_count_label.config(text=f"Количество доступных токенов: {len(available_tokens)}")
    blacklisted_token_count_label.config(text=f"Токенов в черном списке: {len(blacklisted_tokens)}")

# Функция для запуска процесса в отдельном потоке
def start_process():
    if not is_running:
        threading.Thread(target=run_process).start()
    else:
        messagebox.showwarning("Внимание", "Процесс уже выполняется.")

# Функция для остановки процесса
def stop_process():
    global is_running
    is_running = False

# Функция для отображения успешных токенов
def show_success_tokens():
    if success_tokens:
        tokens_text = "\n".join(success_tokens)
        messagebox.showinfo("Успешные токены", tokens_text)
    else:
        messagebox.showinfo("Успешные токены", "Нет успешных токенов")

# Функция для отображения неуспешных токенов
def show_failure_tokens():
    if failure_tokens:
        tokens_text = "\n".join(failure_tokens)
        messagebox.showinfo("Неуспешные токены", tokens_text)
    else:
        messagebox.showinfo("Неуспешные токены", "Нет неуспешных токенов")

# Создание контекстного меню для копирования
def create_context_menu(event):
    context_menu = tk.Menu(root, tearoff=0, bg="#3C3C3C", fg="#FFFFFF")
    context_menu.add_command(label="Копировать", command=lambda: root.focus_get().event_generate("<<Copy>>"))
    context_menu.tk_popup(event.x_root, event.y_root)

# Функция для переключения состояния полей ввода года рождения
def toggle_birth_year_fields():
    state = 'normal' if birth_date_var.get() else 'disabled'
    birth_year_from_entry.config(state=state)
    birth_year_to_entry.config(state=state)

# Функция для чтения состояния галочки из файла
def read_checkbox_state():
    try:
        with open(state_file_path, 'r') as file:
            state = file.read().strip()
            return state == "True"
    except FileNotFoundError:
        return False

# Функция для сохранения состояния галочки в файл
def save_checkbox_state(*args):
    state = birth_date_var.get()
    with open(state_file_path, 'w') as file:
        file.write("True" if state else "False")

# Функция для чтения значений задержек из файла
def read_delay_state():
    try:
        with open(delay_state_file_path, 'r') as file:
            lines = file.readlines()
            if len(lines) >= 2:
                return lines[0].strip(), lines[1].strip()
            else:
                return "7", "14"  # Значения по умолчанию
    except FileNotFoundError:
        return "7", "14"  # Значения по умолчанию

# Функция для сохранения значений задержек в файл
def save_delay_state(*args):
    delay_min = delay_min_var.get()
    delay_max = delay_max_var.get()
    with open(delay_state_file_path, 'w') as file:
        file.write(f"{delay_min}\n{delay_max}")

# Создание графического интерфейса
root = tk.Tk()
root.title("Изменить имена и фамилии ВК")
root.geometry("800x750")
root.configure(bg="#2C2C2C")  # Темный фон для главного окна

# Центрирование окна
def center_window():
    root.update_idletasks()  # Обновляем информацию о размерах
    window_width = root.winfo_width()
    window_height = root.winfo_height()
    screen_width = root.winfo_screenwidth()
    screen_height = root.winfo_screenheight()
    x = (screen_width // 2) - (window_width // 2)
    y = (screen_height // 2) - (window_height // 2)
    root.geometry(f"{window_width}x{window_height}+{x}+{y}")

# Цвета для темной темы
bg_color = "#2C2C2C"
fg_color = "#FFFFFF"
button_bg = "#3C3C3C"
button_fg = "#FFFFFF"
entry_bg = "#3C3C3C"
entry_fg = "#FFFFFF"
text_bg = "#3C3C3C"
text_fg = "#FFFFFF"
success_color = "#00FF00"  # Ярко-зеленый для успешных операций
failure_color = "#FF0000"  # Ярко-красный для неуспешных операций

start_button = tk.Button(root, text="Запустить", command=start_process, bg=button_bg, fg=button_fg)
start_button.pack(pady=10)

stop_button = tk.Button(root, text="Остановить", command=stop_process, bg=button_bg, fg=button_fg)
stop_button.pack(pady=10)

delay_min_label = tk.Label(root, text="Задержка от (сек):", bg=bg_color, fg=fg_color)
delay_min_label.pack()
delay_min_var = tk.StringVar()
delay_min_entry = tk.Entry(root, textvariable=delay_min_var, bg=entry_bg, fg=entry_fg, insertbackground=fg_color)
delay_min_entry.pack(pady=5)

delay_max_label = tk.Label(root, text="Задержка до (сек):", bg=bg_color, fg=fg_color)
delay_max_label.pack()
delay_max_var = tk.StringVar()
delay_max_entry = tk.Entry(root, textvariable=delay_max_var, bg=entry_bg, fg=entry_fg, insertbackground=fg_color)
delay_max_entry.pack(pady=5)

birth_year_from_label = tk.Label(root, text="Год рождения от:", bg=bg_color, fg=fg_color)
birth_year_from_label.pack()
birth_year_from_entry = tk.Entry(root, bg=entry_bg, fg=entry_fg, insertbackground=fg_color)
birth_year_from_entry.insert(0, "1970")
birth_year_from_entry.pack(pady=5)

birth_year_to_label = tk.Label(root, text="Год рождения до:", bg=bg_color, fg=fg_color)
birth_year_to_label.pack()
birth_year_to_entry = tk.Entry(root, bg=entry_bg, fg=entry_fg, insertbackground=fg_color)
birth_year_to_entry.insert(0, "1990")
birth_year_to_entry.pack(pady=5)

# Галочка для управления изменением даты рождения
birth_date_var = tk.BooleanVar()
saved_state = read_checkbox_state()
birth_date_var.set(saved_state)
birth_date_check = tk.Checkbutton(root, text="Изменять дату рождения", variable=birth_date_var, command=toggle_birth_year_fields, bg=bg_color, fg=fg_color, selectcolor=button_bg)
birth_date_check.pack(pady=5)

# Изначально отключаем поля
birth_year_from_entry.config(state='disabled')
birth_year_to_entry.config(state='disabled')

# Метки для статистики
success_label = tk.Label(root, text="Успешно: 0", font=("Helvetica", 12, "bold"), fg=success_color, bg=bg_color)
success_label.pack(pady=5)

failure_label = tk.Label(root, text="Неуспешно: 0", font=("Helvetica", 12, "bold"), fg=failure_color, bg=bg_color)
failure_label.pack(pady=5)

total_token_count_label = tk.Label(root, text="Количество всего токенов: 0", font=("Helvetica", 12, "bold"), fg=fg_color, bg=bg_color)
total_token_count_label.pack(pady=5)

token_count_label = tk.Label(root, text="Количество доступных токенов: 0", font=("Helvetica", 12, "bold"), fg=fg_color, bg=bg_color)
token_count_label.pack(pady=5)

blacklisted_token_count_label = tk.Label(root, text="Токенов в черном списке: 0", font=("Helvetica", 12, "bold"), fg=fg_color, bg=bg_color)
blacklisted_token_count_label.pack(pady=5)

load_token_count()

show_success_button = tk.Button(root, text="Показать успешные токены", command=show_success_tokens, bg=button_bg, fg=button_fg)
show_success_button.pack(pady=5)

show_failure_button = tk.Button(root, text="Показать неуспешные токены", command=show_failure_tokens, bg=button_bg, fg=button_fg)
show_failure_button.pack(pady=5)

log_text = tk.Text(root, height=20, width=100, wrap=tk.WORD, bg=text_bg, fg=text_fg, insertbackground=fg_color)
log_text.pack(pady=10)
log_text.bind("<Button-3>", create_context_menu)

# Установка начального состояния и отслеживание изменений
toggle_birth_year_fields()
birth_date_var.trace("w", save_checkbox_state)

# Чтение сохраненных значений задержек
saved_delay_min, saved_delay_max = read_delay_state()
delay_min_var.set(saved_delay_min)
delay_max_var.set(saved_delay_max)

# Отслеживание изменений в полях задержек
delay_min_var.trace("w", save_delay_state)
delay_max_var.trace("w", save_delay_state)

# Центрирование окна при запуске
center_window()

root.mainloop()